#define DELAY0 10000 // Pause 0, 10 secondes
#define DELAY1 1000  // Pause 1, 1 seconde
#define DELAY2 2000  // Pause 2, 2 secondes
#define DELAY3 3000  // Pause 3, 3 secondes
int ledPinRougeCar = 7;     // La broche 7 commande la LED rouge
                            // (feux pour les automobilistes)
int ledPinOrangeCar = 6;    // La broche 6 commande la LED orange
int ledPinGreenCar = 5;     // La broche 5 commande la LED verte
int ledPinRedWalk = 3;      // La broche 3 commande la LED rouge
                            // (feux pour les piétons)
int ledPinGreenWalk = 2;    // La broche 2 commande la LED verte
int buttonPinLight = 8;     // Bouton gérant les feux reliés à la broche 8
int buttonLightValue = LOW; // Variable pour l'état du bouton gérant les feux

void lightChange(){
   digitalWrite(ledPinGreenCar, LOW); 
   digitalWrite(ledPinOrangeCar, HIGH); delay(DELAY3);
   digitalWrite(ledPinOrangeCar, LOW);
   digitalWrite(ledPinRougeCar, HIGH); delay(DELAY1);
   digitalWrite(ledPinRedWalk, LOW);
   digitalWrite(ledPinGreenWalk, HIGH); delay(DELAY0);
   digitalWrite(ledPinGreenWalk, LOW);
   digitalWrite(ledPinRedWalk, HIGH); delay(DELAY1);
   digitalWrite(ledPinOrangeCar, HIGH); delay(DELAY2);
   digitalWrite(ledPinRougeCar, LOW);
   digitalWrite(ledPinOrangeCar, LOW);
   digitalWrite(ledPinGreenCar, HIGH);
}

void setup(){                
  pinMode(ledPinRougeCar, OUTPUT);      // Broche comme sortie 
  pinMode(ledPinOrangeCar, OUTPUT);     // Broche comme sortie 
  pinMode(ledPinGreenCar, OUTPUT);      // Broche comme sortie 
  pinMode(ledPinRedWalk, OUTPUT);       // Broche comme sortie 
  pinMode(ledPinGreenWalk, OUTPUT);     // Broche comme sortie 
  pinMode(buttonPinLight, INPUT);       // Broche comme entrée
  digitalWrite(ledPinGreenCar, HIGH);   // Valeur de départ (vert pour les automobilistes)
  digitalWrite(ledPinRedWalk, HIGH);    // Valeur de départ (rouge pour les piétons)
}
void loop(){
  // Lire l'état du bouton gérant les feux dans la variable
  buttonLightValue = digitalRead(buttonPinLight);
  // Si bouton pressé, fonction appelée
  if(buttonLightValue == HIGH)
    lightChange();
}
